<?php
require_once "../config/db.php";
require_once "../includes/auth.php";
requireUserLogin();

$user_id = $_SESSION['user_id'];
$order_id = (int)($_GET['id'] ?? 0);

// fetch order
$stmt = $conn->prepare("SELECT * FROM orders WHERE id = ? AND user_id = ?");
$stmt->bind_param("ii", $order_id, $user_id);
$stmt->execute();
$order = $stmt->get_result()->fetch_assoc();

include "../includes/header.php";
?>
<div class="table-card">
<?php if(!$order): ?>
    <p>Order not found.</p>
<?php else: ?>
    <h2>Order #<?php echo $order['id']; ?></h2>
    <p><strong>Date:</strong> <?php echo $order['created_at']; ?></p>
    <p><strong>Status:</strong> <?php echo htmlspecialchars($order['status']); ?></p>
    <p><strong>Delivery Address:</strong><br><?php echo nl2br(htmlspecialchars($order['delivery_address'])); ?></p>

    <h3>Items</h3>
    <table class="table">
        <thead>
            <tr>
                <th>Fruit</th>
                <th>Qty</th>
                <th>Unit Price</th>
                <th>Subtotal</th>
            </tr>
        </thead>
        <tbody>
        <?php
        $itemStmt = $conn->prepare("SELECT oi.*, f.name 
                                    FROM order_items oi 
                                    LEFT JOIN fruits f ON oi.fruit_id = f.id 
                                    WHERE oi.order_id = ?");
        $itemStmt->bind_param("i", $order_id);
        $itemStmt->execute();
        $items = $itemStmt->get_result();
        while ($item = $items->fetch_assoc()):
        ?>
            <tr>
                <td><?php echo htmlspecialchars($item['name']); ?></td>
                <td><?php echo (int)$item['quantity']; ?></td>
                <td>₹<?php echo number_format($item['unit_price'], 2); ?></td>
                <td>₹<?php echo number_format($item['unit_price'] * $item['quantity'], 2); ?></td>
            </tr>
        <?php endwhile; ?>
        </tbody>
    </table>
    <p style="margin-top:10px;"><strong>Total:</strong> ₹<?php echo number_format($order['total_amount'], 2); ?></p>
<?php endif; ?>
</div>
<?php include "../includes/footer.php"; ?>
