<?php
require_once "config/db.php";

// Create default admin
$adminEmail = "admin@fruitbasket.com";
$adminPass = password_hash("admin123", PASSWORD_BCRYPT);
$conn->query("INSERT IGNORE INTO admins (email, password_hash) VALUES ('$adminEmail', '$adminPass')");

// Categories
$categories = ['Citrus', 'Berries', 'Seasonal', 'Imported', 'Tropical', 'Stone Fruits', 'Melons'];
foreach ($categories as $cat) {
    $stmt = $conn->prepare("INSERT IGNORE INTO categories (name) VALUES (?)");
    $stmt->bind_param("s", $cat);
    $stmt->execute();
}

// Sample users
$users = [
    ['Rohan Sharma','rohan@example.com','9876543210','rohan123','Delhi'],
    ['Priya Verma','priya@example.com','9876501234','priya123','Mumbai'],
];
foreach ($users as $u) {
    [$name,$email,$mobile,$pass,$address] = $u;
    $hash = password_hash($pass, PASSWORD_BCRYPT);
    $stmt = $conn->prepare("INSERT IGNORE INTO users (name, email, mobile, password_hash, address, status) VALUES (?, ?, ?, ?, ?, 1)");
    $stmt->bind_param("sssss", $name, $email, $mobile, $hash, $address);
    $stmt->execute();
}

// Fruits (ensure categories exist)
$categoryMap = [];
$res = $conn->query("SELECT id, name FROM categories");
while ($row = $res->fetch_assoc()) {
    $categoryMap[$row['name']] = $row['id'];
}

$fruits = [
    ['Nagpur Oranges', 'Citrus', 80.00, 'kg', 50, 'Juicy and sweet Nagpur oranges, rich in vitamin C.', 'orange.jpg'],
    ['Alphonso Mango', 'Seasonal', 250.00, 'dozen', 30, 'Premium Alphonso mangoes with rich aroma and taste.', 'mango.jpg'],
    ['Strawberries', 'Berries', 180.00, 'box', 40, 'Fresh red strawberries perfect for desserts.', 'strawberry.jpg'],
    ['Green Grapes', 'Imported', 120.00, 'kg', 60, 'Crisp seedless green grapes.', 'grapes.jpg'],
    ['Bananas', 'Tropical', 50.00, 'dozen', 100, 'Sweet ripe bananas for daily energy.', 'banana.jpg'],
    ['Watermelon', 'Melons', 60.00, 'kg', 25, 'Hydrating and refreshing watermelons.', 'watermelon.jpg'],
    ['Peaches', 'Stone Fruits', 220.00, 'kg', 20, 'Soft and aromatic peaches.', 'peach.jpg'],
];

foreach ($fruits as $f) {
    [$name,$catName,$price,$unit,$stock,$desc,$img] = $f;
    $catId = $categoryMap[$catName] ?? null;
    if ($catId) {
        $stmt = $conn->prepare("INSERT INTO fruits (name, category_id, price_per_unit, unit, stock_quantity, short_description, image, is_active) VALUES (?, ?, ?, ?, ?, ?, ?, 1)");
        $stmt->bind_param("sidsiss", $name, $catId, $price, $unit, $stock, $desc, $img);
        $stmt->execute();
    }
}

echo "Seeding completed.";
