<?php
require_once "../config/db.php";
require_once "../includes/auth.php";

$message = "";
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email = trim($_POST['email'] ?? '');
    $password = $_POST['password'] ?? '';

    $stmt = $conn->prepare("SELECT id, password_hash, status FROM users WHERE email = ?");
    $stmt->bind_param("s", $email);
    $stmt->execute();
    $stmt->bind_result($id, $hash, $status);
    if ($stmt->fetch()) {
        if ((int)$status === 0) {
            $message = "Your account is deactivated. Contact support.";
        } elseif (password_verify($password, $hash)) {
            $_SESSION['user_id'] = $id;
            $_SESSION['user_email'] = $email;
            header("Location: index.php");
            exit;
        } else {
            $message = "Invalid email or password.";
        }
    } else {
        $message = "Invalid email or password.";
    }
}
include "../includes/header.php";
?>
<div class="form-card">
    <h2>User Login</h2>
    <?php if($message): ?>
        <div class="alert alert-error"><?php echo htmlspecialchars($message); ?></div>
    <?php endif; ?>
    <form method="post" action="">
        <div class="form-group">
            <label>Email</label>
            <input type="email" name="email" required/>
        </div>
        <div class="form-group">
            <label>Password</label>
            <input type="password" name="password" required/>
        </div>
        <div class="form-actions">
            <button type="submit" class="btn">Login</button>
        </div>
    </form>
</div>
<?php include "../includes/footer.php"; ?>
