<?php
require_once "../config/db.php";
require_once "../includes/auth.php";
require_once "../includes/cart_functions.php";
include "../includes/header.php";

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['update'])) {
        foreach ($_POST['qty'] as $fruit_id => $qty) {
            updateCartQuantity((int)$fruit_id, (int)$qty);
        }
    } elseif (isset($_POST['remove'])) {
        $fruit_id = (int)$_POST['fruit_id'];
        removeFromCart($fruit_id);
    }
}
?>
<div class="table-card">
    <h2>Your Cart</h2>
    <form method="post">
        <table class="table">
            <thead>
                <tr>
                    <th>Fruit</th>
                    <th>Unit Price</th>
                    <th>Qty</th>
                    <th>Subtotal</th>
                    <th></th>
                </tr>
            </thead>
            <tbody>
            <?php if (!empty($_SESSION['cart'])): ?>
                <?php foreach($_SESSION['cart'] as $id => $item): ?>
                    <tr>
                        <td><?php echo htmlspecialchars($item['name']); ?></td>
                        <td>₹<?php echo number_format($item['price'], 2); ?></td>
                        <td>
                            <input type="number" name="qty[<?php echo $id; ?>]" value="<?php echo (int)$item['qty']; ?>" min="1" style="width:60px;">
                        </td>
                        <td>₹<?php echo number_format($item['price'] * $item['qty'], 2); ?></td>
                        <td>
                            <button type="submit" name="remove" value="1" class="btn-outline">Remove</button>
                            <input type="hidden" name="fruit_id" value="<?php echo $id; ?>"/>
                        </td>
                    </tr>
                <?php endforeach; ?>
                <tr>
                    <td colspan="3" style="text-align:right;"><strong>Total:</strong></td>
                    <td colspan="2"><strong>₹<?php echo number_format(getCartTotal(), 2); ?></strong></td>
                </tr>
            <?php else: ?>
                <tr><td colspan="5">Your cart is empty.</td></tr>
            <?php endif; ?>
            </tbody>
        </table>
        <?php if (!empty($_SESSION['cart'])): ?>
            <div class="form-actions">
                <button type="submit" name="update" class="btn">Update Cart</button>
                <a href="checkout.php" class="btn">Proceed to Checkout</a>
            </div>
        <?php endif; ?>
    </form>
</div>
<?php include "../includes/footer.php"; ?>
