<?php
require_once "../config/db.php";
require_once "../includes/auth.php";

$message = "";
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email = trim($_POST['email'] ?? '');
    $password = $_POST['password'] ?? '';

    $stmt = $conn->prepare("SELECT id, password_hash FROM admins WHERE email = ?");
    $stmt->bind_param("s", $email);
    $stmt->execute();
    $stmt->bind_result($id, $hash);
    if ($stmt->fetch() && password_verify($password, $hash)) {
        $_SESSION['admin_id'] = $id;
        $_SESSION['admin_email'] = $email;
        header("Location: index.php");
        exit;
    } else {
        $message = "Invalid admin credentials.";
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Admin Login - Online Fruit Order</title>
    <link href="../public/assets/css/style.css" rel="stylesheet">
</head>
<body>
<div class="form-card">
    <h2>Admin Login</h2>
    <?php if($message): ?>
        <div class="alert alert-error"><?php echo htmlspecialchars($message); ?></div>
    <?php endif; ?>
    <form method="post">
        <div class="form-group">
            <label>Email / Username</label>
            <input type="text" name="email" required/>
        </div>
        <div class="form-group">
            <label>Password</label>
            <input type="password" name="password" required/>
        </div>
        <div class="form-actions">
            <button type="submit" class="btn">Login</button>
        </div>
    </form>
</div>
</body>
</html>
