<?php
require_once "../config/db.php";
include "header.php";

$message = "";

// Create / Update
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = trim($_POST['name'] ?? '');
    $id = (int)($_POST['id'] ?? 0);

    if ($id > 0) {
        $stmt = $conn->prepare("UPDATE categories SET name = ? WHERE id = ?");
        $stmt->bind_param("si", $name, $id);
        $stmt->execute();
        $message = "Category updated.";
    } else {
        $stmt = $conn->prepare("INSERT INTO categories (name) VALUES (?)");
        $stmt->bind_param("s", $name);
        $stmt->execute();
        $message = "Category added.";
    }
}

// Delete
if (isset($_GET['delete'])) {
    $id = (int)$_GET['delete'];
    // Check if fruits exist
    $stmt = $conn->prepare("SELECT COUNT(*) FROM fruits WHERE category_id = ?");
    $stmt->bind_param("i", $id);
    $stmt->execute();
    $stmt->bind_result($cnt);
    $stmt->fetch();
    if ($cnt > 0) {
        $message = "Cannot delete category with linked fruits.";
    } else {
        $conn->query("DELETE FROM categories WHERE id = $id");
        $message = "Category deleted.";
    }
}

// Edit
$editCategory = null;
if (isset($_GET['edit'])) {
    $id = (int)$_GET['edit'];
    $res = $conn->query("SELECT * FROM categories WHERE id = $id");
    $editCategory = $res->fetch_assoc();
}

$categories = $conn->query("SELECT * FROM categories ORDER BY name");
?>
<div class="table-card">
    <h2>Fruit Categories</h2>
    <?php if($message): ?>
        <div class="alert alert-success"><?php echo htmlspecialchars($message); ?></div>
    <?php endif; ?>
    <form method="post" style="margin-bottom:20px;">
        <input type="hidden" name="id" value="<?php echo $editCategory['id'] ?? ''; ?>"/>
        <div class="form-group">
            <label>Category Name</label>
            <input type="text" name="name" value="<?php echo htmlspecialchars($editCategory['name'] ?? ''); ?>" required/>
        </div>
        <button type="submit" class="btn"><?php echo $editCategory ? 'Update Category' : 'Add Category'; ?></button>
    </form>
    <table class="table">
        <thead>
            <tr>
                <th>#</th>
                <th>Category</th>
                <th></th>
            </tr>
        </thead>
        <tbody>
            <?php while ($cat = $categories->fetch_assoc()): ?>
                <tr>
                    <td><?php echo $cat['id']; ?></td>
                    <td><?php echo htmlspecialchars($cat['name']); ?></td>
                    <td>
                        <a href="?edit=<?php echo $cat['id']; ?>">Edit</a> | 
                        <a href="?delete=<?php echo $cat['id']; ?>" onclick="return confirm('Delete this category?')">Delete</a>
                    </td>
                </tr>
            <?php endwhile; ?>
        </tbody>
    </table>
</div>
<?php include "footer.php"; ?>
